
#include "gridparam.h"

GridParam::GridParam()
{
    GridParam::xmin = -1;
    GridParam::ymin = 1;
    GridParam::zmin = 0;
    GridParam::xmax = 0;
    GridParam::ymax = 0;
    GridParam::zmax = 0;
    GridParam::nx=10;
    GridParam::ny=0;
    GridParam::nz=0;

    dim=1;
}

GridParam::GridParam(const double &xmin, const double &xmax, const long int &nx,
                     const double &ymin, const double &ymax, const long int &ny,
                     const double &zmin, const double &zmax, const long int &nz)
{
    GridParam::xmin = xmin;
    GridParam::ymin = ymin;
    GridParam::zmin = zmin;
    GridParam::xmax = xmax;
    GridParam::ymax = ymax;
    GridParam::zmax = zmax;
    GridParam::nx=nx;
    GridParam::ny=ny;
    GridParam::nz=nz;

    SetDim();
}


GridParam::GridParam(ifstream &inputGP)
{
    try {
        FromFile(inputGP);
    } catch (...) {
        throw "No data in file";
    }
}

void GridParam::FromFile(ifstream &inputGP)
{
    if (!inputGP.eof()) inputGP>>xmin>>xmax>>nx;
    else throw "No data in file";
    if (!inputGP.eof()) inputGP>>ymin>>ymax>>ny;
    else ymin=ymax=ny=0;
    if (!inputGP.eof()) inputGP>>zmin>>zmax>>nz;
    else zmin=zmax=nz=0;

    if (!ny) dim=1;
    else if (!nz) dim=2;
    else dim=3;
}

void GridParam::SetXRange(const double &xmin, const double &xmax, const long int &nx)
{
    GridParam::xmin = xmin;
    GridParam::xmax = xmax;
    GridParam::nx=nx;
    try {
        SetDim();
    } catch (...) {
        throw "Xmin must be different from xmax";
    }
    return;
}

void GridParam::SetYRange(const double &ymin, const double &ymax, const long int &ny)
{
    GridParam::ymin = ymin;
    GridParam::ymax = ymax;
    GridParam::ny=ny;
    try {
        SetDim();
    } catch (...) {
        throw "Xmin must be different from xmax";
    }
    return;
}

void GridParam::SetZRange(const double &zmin, const double &zmax, const long int &nz)
{
    GridParam::zmin = zmin;
    GridParam::zmax = zmax;
    GridParam::nz=nz;
    try {
        SetDim();
    } catch (...) {
        throw "Xmin must be different from xmax";
    }
    return;
}

void GridParam::GetXRange(double &xmin, double &xmax, long int &nx) const
{
    xmin = GridParam::xmin;
    xmax = GridParam::xmax;
    nx = GridParam::nx;

    return;
}

void GridParam::GetYRange(double &ymin, double &ymax, long int &ny) const
{
    ymin = GridParam::ymin;
    ymax = GridParam::ymax;
    ny = GridParam::ny;

    return;
}

void GridParam::GetZRange(double &zmin, double &zmax, long int &nz) const
{
    zmin = GridParam::zmin;
    zmax = GridParam::zmax;
    nz = GridParam::nz;

    return;
}

void GridParam::SetDim()
{
    if (xmin==xmax) throw "Xmin must be different from xmax";
    else if (ymin==ymax) dim=1;
    else if (zmin==zmax) dim=2;
    else dim=3;
}

double GridParam::GetDx() const
{
    if (dim>=1) return (xmax-xmin)/(nx-1);
    return 0.0;
}

double GridParam::GetDy() const
{
    if (dim>=2) return (ymax-ymin)/(ny-1);
    return 0.0;
}

double GridParam::GetDz() const
{
    if (dim>=3) return (zmax-zmin)/(nz-1);
    return 0.0;
}

long int GridParam::GetDim() const
{
    return dim;
}

long int GridParam::GetNmax() const
{
    switch (dim) {
        case 1  : return nx;
        case 2  : return nx*ny;
        default : return nx*ny*nz;
    }
}

long int GridParam::GetNx() const
{
    return nx;
}

long int GridParam::GetNy() const
{
    return ny;
}

long int GridParam::GetNz() const
{
    return nz;
}

double GridParam::GetXmin() const
{
    return xmin;
}

double GridParam::GetYmin() const
{
    return ymin;
}

double GridParam::GetZmin() const
{
    return zmin;
}

double GridParam::GetXmax() const
{
    return xmax;
}

double GridParam::GetYmax() const
{
    return ymax;
}

double GridParam::GetZmax() const
{
    return zmax;
}

GridParam &GridParam::operator=(const GridParam &gp)
{
    xmin = gp.xmin;
    ymin = gp.ymin;
    zmin = gp.zmin;
    xmax = gp.xmax;
    ymax = gp.ymax;
    zmax = gp.zmax;
    nx = gp.nx;
    ny = gp.ny;
    nz = gp.nz;
    dim = gp.dim;

    return *this;
}

long int GridParam::Round(const double &l) const
{
    double tmpl=(long int)l;
    tmpl+=0.5;
    tmpl=tmpl>l?tmpl-0.5:tmpl+0.5;
    return (long int)tmpl;
}

long int GridParam::GetIndexZ(const double &z)
{
	return Round((z-GetZmin())/GetDz());
}

long int GridParam::GetIndexY(const double &y)
{
    return Round((y-GetYmin())/GetDy());
}

long int GridParam::GetIndexX(const double &x)
{
    return Round((x-GetXmin())/GetDx());
}
